package de.bebagoe.tableviewproper;

// Quellen:
//   https://docs.oracle.com/javafx/2/ui_controls/table-view.htm
//   https://docs.oracle.com/javase/8/javafx/api/javafx/scene/control/TableView.html

import javafx.beans.property.*;
import javafx.application.Application;
import javafx.beans.property.StringProperty;
import javafx.collections.*;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.control.cell.*;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.StringConverter;
import javafx.util.converter.LocalDateStringConverter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;

public class TableViewProper extends Application {
	@Override
	public void start(Stage stage) {
		var table = new TableView<Person>();
		table.setEditable(true);

		final var creationDateCol = new TableColumn<Person,LocalDate>("Angelegt");
		creationDateCol.setMinWidth(50);
		creationDateCol.setCellValueFactory(new PropertyValueFactory<>("creationDate"));

		final var firstNameCol = new TableColumn<Person,String>("Vorname");
		firstNameCol.setMinWidth(100);
		firstNameCol.setCellValueFactory(new PropertyValueFactory<>("firstName"));
		firstNameCol.setCellFactory(TextFieldTableCell.forTableColumn());
		firstNameCol.setOnEditCommit(t -> t.getTableView().getItems().get(
											t.getTablePosition().getRow()).setFirstName(t.getNewValue()));

		final var lastNameCol = new TableColumn<Person,String>("Nachname");
		lastNameCol.setMinWidth(100);
		lastNameCol.setCellValueFactory(new PropertyValueFactory<>("lastName"));
		lastNameCol.setCellFactory(TextFieldTableCell.forTableColumn());
		lastNameCol.setOnEditCommit(t -> t.getTableView().getItems().get(
						                   t.getTablePosition().getRow()).setLastName(t.getNewValue()));

		final var birthdayCol = new TableColumn<Person,LocalDate>("Geburtstag");
		birthdayCol.setMinWidth(50);
		birthdayCol.setCellValueFactory(new PropertyValueFactory<>("birthday"));
		birthdayCol.setCellFactory(TextFieldTableCell.forTableColumn(new LocalDateStringConverter()));
		birthdayCol.setOnEditCommit(t -> t.getTableView().getItems().get(
				                           t.getTablePosition().getRow()).setBirthday(t.getNewValue()));

		table.getColumns().addAll(creationDateCol, firstNameCol, lastNameCol, birthdayCol);

		final ObservableList<Person> data =	FXCollections.observableArrayList(
			new Person("Kurt", "Saar", "1972-09-23"),
			new Person("Karl", "Rempremerding", "1949-12-17"),
			new Person("Hilde", "Becker", "1969-10-09"),
			new Person("Otto", "Brgl", "2001-07-22")
		);
		table.setItems(data);

		final var vbox = new VBox();
		vbox.setSpacing(5);
		vbox.getChildren().addAll(table);

		stage.setScene(new Scene(vbox, 400, 300));
		stage.setTitle("Adressbuch");
		stage.show();
	}

	public static void main(String[] args) { launch(args); }
}